<?php
/*--------------------------------------------------------------------------------------------------
    PropertyQuantityrepositoryInterface.php 2020-02-21
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Repositories;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\Properties\Properties\Collections\CombinationCollectionInterface;
use Gambio\Shop\Properties\Properties\Entities\Combination;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\CombinationQuantity;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\PropertyTotalQuantity;
use ProductDataInterface;

interface PropertyQuantityRepositoryInterface
{
    
    /**
     * @param ProductId            $id
     * @param ProductDataInterface $product
     *
     * @return mixed
     */
    public function getTotalQuantityForProduct(ProductId $id, ProductDataInterface $product): ?PropertyTotalQuantity;
    
    
    /**
     * @param Combination          $combination
     * @param ProductDataInterface $product
     *
     * @return mixed
     */
    public function getQuantityByCombination(Combination $combination, ProductDataInterface $product): ?CombinationQuantity;
    
    
    /**
     * @param                      $combinations
     * @param ProductId            $productId
     * @param ProductDataInterface $product
     *
     * @return mixed
     */
    public function totalizeQuantities(CombinationCollectionInterface $combinations, ProductId $productId, ProductDataInterface $product);
}